<?php
require __DIR__ . '/includes/db.php';

// ✅ JANGAN REDIRECT OTOMATIS
$loggedIn = !empty($_SESSION['user_id']);

$notif = '';
$justRegistered = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !$loggedIn) {
  $name  = trim($_POST['name'] ?? '');
  $email = trim($_POST['email'] ?? '');
  $phone = trim($_POST['phone'] ?? '');
  $pass  = $_POST['password']  ?? '';
  $pass2 = $_POST['password2'] ?? '';

  if ($name==='' || $email==='' || $pass==='') {
    $notif = "<div class='alert error'>Nama, Email, dan Password wajib diisi.</div>";
  } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $notif = "<div class='alert error'>Format email tidak valid.</div>";
  } elseif (strlen($pass) < 6) {
    $notif = "<div class='alert error'>Password minimal 6 karakter.</div>";
  } elseif ($pass !== $pass2) {
    $notif = "<div class='alert error'>Konfirmasi password tidak sama.</div>";
  } else {
    // cek email unik
    $em  = mysqli_real_escape_string($conn, $email);
    $cek = mysqli_fetch_assoc(mysqli_query($conn, "SELECT id FROM users WHERE email='$em' LIMIT 1"));
    if ($cek) {
      $notif = "<div class='alert error'>Email sudah terdaftar. Silakan login.</div>";
    } else {
      $nameEsc  = mysqli_real_escape_string($conn, $name);
      $phoneEsc = mysqli_real_escape_string($conn, $phone);
      $hash     = password_hash($pass, PASSWORD_DEFAULT);

      $sql = "INSERT INTO users(role,name,email,phone,password_hash,is_active,created_at,updated_at)
              VALUES('buyer','$nameEsc','$em','$phoneEsc','$hash',1,NOW(),NOW())";
      if (mysqli_query($conn,$sql)) {
        // auto-login
        $_SESSION['user_id']    = mysqli_insert_id($conn);
        $_SESSION['user_role']  = 'buyer';
        $_SESSION['user_name']  = $name;
        $_SESSION['user_email'] = $email;
        $loggedIn = true;
        $justRegistered = true;
        $notif = "<div class='alert success'>Akun berhasil dibuat. Selamat datang, <b>".e($name)."</b>!</div>";
      } else {
        $notif = "<div class='alert error'>Gagal menyimpan akun: ".e(mysqli_error($conn))."</div>";
      }
    }
  }
}

include __DIR__ . '/includes/navbar.php';
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Daftar Akun | Cremoid</title>
<style>
:root{--c-blue:#005ca8;--line:#e9eaef;--soft:#f6f7fb}
body{margin:0;background:var(--soft);font:15px/1.6 system-ui,Segoe UI,Roboto,Arial;color:#1b1e23}
.auth-page{max-width:900px;margin:20px auto;padding:0 16px}
.auth-card{background:#fff;border:1px solid var(--line);border-radius:14px;box-shadow:0 8px 22px rgba(0,0,0,.08);padding:24px}
.auth-card h1{margin:0 0 8px;font:800 26px/1.2 system-ui;color:#005ca8}
.auth-card p{margin:0 0 18px;color:#425466}
.grid{display:grid;gap:14px;grid-template-columns:1fr 1fr}
@media(max-width:760px){.grid{grid-template-columns:1fr}}
label{font-weight:700;display:block;margin:6px 0}
input{width:100%;padding:12px;border:1px solid #e1e3ea;border-radius:10px}
button{padding:12px 18px;border:none;border-radius:10px;background:#005ca8;color:#fff;font-weight:800;cursor:pointer}
button:hover{filter:brightness(.95)}
.alt{margin-top:12px;font-size:14px}
.alert{padding:12px;border-radius:10px;margin-bottom:14px}
.alert.error{background:#ffecec;color:#a51616}
.alert.success{background:#e7f8ec;color:#0a6c0a}
.tools{display:flex;gap:10px;flex-wrap:wrap;margin:12px 0}
.btn{padding:10px 14px;border-radius:10px;border:1px solid var(--line);background:#fff;text-decoration:none;color:#111;font-weight:700}
.btn.primary{background:var(--c-blue);border-color:var(--c-blue);color:#fff}
</style>
</head>
<body>
  <div class="auth-page">
    <div class="auth-card">
      <h1>Buat Akun</h1>
      <p>Daftar untuk mengelola penjualan, pengajuan kredit, dan favorit Anda di Cremoid.</p>

      <?= $notif ?>

      <?php if ($loggedIn): ?>
        <div class="alert success">
          <?= $justRegistered ? 'Akun berhasil dibuat dan Anda sudah login.' : 'Anda sudah login.' ?>
        </div>
        <div class="tools">
          <a class="btn primary" href="<?= e(url('/profile.php')) ?>">Ke Profil</a>
          <a class="btn" href="<?= e(url('/logout.php')) ?>">Keluar</a>
          <a class="btn" href="<?= e(url('/')) ?>">Beranda</a>
        </div>
      <?php else: ?>
        <form method="post" autocomplete="on" novalidate>
          <div class="grid">
            <div>
              <label>Nama Lengkap</label>
              <input type="text" name="name" value="<?= e($_POST['name'] ?? '') ?>" required>
            </div>
            <div>
              <label>No. HP / WhatsApp</label>
              <input type="text" name="phone" inputmode="tel" value="<?= e($_POST['phone'] ?? '') ?>">
            </div>
          </div>

          <div class="grid">
            <div>
              <label>Email</label>
              <input type="email" name="email" value="<?= e($_POST['email'] ?? '') ?>" required>
            </div>
            <div>
              <label>Password</label>
              <input type="password" name="password" minlength="6" required>
            </div>
          </div>

          <div>
            <label>Konfirmasi Password</label>
            <input type="password" name="password2" minlength="6" required>
          </div>

          <button type="submit">Daftar</button>
        </form>

        <div class="alt">Sudah punya akun? <a href="<?= e(url('/login.php')) ?>">Masuk di sini</a></div>
      <?php endif; ?>
    </div>
  </div>

  <?php include __DIR__ . '/includes/footer.php'; ?>
</body>
</html>
