<?php
include '../includes/session.php';
include '../includes/functions.php';
include '../includes/db.php';

cek_role(['komisaris', 'direktur', 'akuntan']);

$success = '';
$error = '';

// Proses input pemasukan
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $tanggal = $_POST['tanggal'];
    $kategori = mysqli_real_escape_string($conn, $_POST['kategori']);
    $keterangan = mysqli_real_escape_string($conn, $_POST['keterangan']);
    $jumlah = floatval($_POST['jumlah']);
    $created_by = $_SESSION['user_id'];

    // Simpan ke tabel pemasukan
    $kategori_id = null;
    $cek = mysqli_query($conn, "SELECT id FROM kategori WHERE nama='$kategori' AND jenis='pemasukan'");
    if ($row = mysqli_fetch_assoc($cek)) {
        $kategori_id = $row['id'];
    } else {
        mysqli_query($conn, "INSERT INTO kategori (nama, jenis) VALUES ('$kategori', 'pemasukan')");
        $kategori_id = mysqli_insert_id($conn);
    }

    $insert = mysqli_query($conn, "
        INSERT INTO pemasukan (tanggal, kategori_id, keterangan, jumlah, created_by)
        VALUES ('$tanggal', '$kategori_id', '$keterangan', '$jumlah', '$created_by')
    ");

    if ($insert) {
        // Hitung dan simpan alokasi otomatis
        $bulan = date('m', strtotime($tanggal));
        $tahun = date('Y', strtotime($tanggal));
        $alokasi = hitung_alokasi($jumlah);

        mysqli_query($conn, "
            INSERT INTO alokasi_pemasukan (bulan, tahun, total_pemasukan, 
                untuk_gaji, untuk_marketing, untuk_operasional, untuk_overhead, tanggal_alokasi)
            VALUES ('$bulan', '$tahun', '$jumlah',
                '{$alokasi['gaji']}', '{$alokasi['marketing']}', '{$alokasi['operasional']}', '{$alokasi['overhead']}', '$tanggal')
        ");

        $success = "Pemasukan berhasil disimpan dan alokasi tercatat otomatis.";
    } else {
        $error = "Gagal menyimpan pemasukan.";
    }
}

// Ambil histori bulan ini
$bulan = date('m');
$tahun = date('Y');
$histori = mysqli_query($conn, "
    SELECT p.tanggal, k.nama AS kategori, p.keterangan, p.jumlah 
    FROM pemasukan p
    LEFT JOIN kategori k ON p.kategori_id = k.id
    WHERE MONTH(p.tanggal) = '$bulan' AND YEAR(p.tanggal) = '$tahun'
    ORDER BY p.tanggal DESC
");
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Input Pemasukan</title>
  <style>
    body { font-family: sans-serif; background: #f4f4f4; padding: 20px; }
    .container { max-width: 800px; margin: auto; background: white; padding: 20px; border-radius: 10px; }
    label { display: block; margin-top: 12px; }
    input, textarea { width: 100%; padding: 8px; margin-top: 4px; }
    button { margin-top: 16px; padding: 10px 20px; background: #003366; color: #fff; border: none; }
    .success { color: green; }
    .error { color: red; }
    table { width: 100%; border-collapse: collapse; margin-top: 20px; }
    th, td { border: 1px solid #ddd; padding: 8px; font-size: 14px; }
    th { background: #003366; color: white; }
  </style>
</head>
<body>

<?php include '../includes/navbar.php'; ?>

<div class="container">
  <h2>Input Pemasukan</h2>

  <?php if ($success): ?><p class="success"><?= $success ?></p><?php endif; ?>
  <?php if ($error): ?><p class="error"><?= $error ?></p><?php endif; ?>

  <form method="POST">
    <label>Tanggal</label>
    <input type="date" name="tanggal" required>

    <label>Kategori</label>
    <input type="text" name="kategori" required placeholder="Contoh: Penjualan Tiket">

    <label>Keterangan</label>
    <textarea name="keterangan" required></textarea>

    <label>Jumlah (Rp)</label>
    <input type="number" name="jumlah" step="100" required>

    <button type="submit">Simpan Pemasukan</button>
  </form>

  <h3>Histori Pemasukan Bulan Ini</h3>
  <table>
    <tr>
      <th>Tanggal</th>
      <th>Kategori</th>
      <th>Keterangan</th>
      <th>Jumlah</th>
    </tr>
    <?php while($row = mysqli_fetch_assoc($histori)): ?>
    <tr>
      <td><?= format_tanggal($row['tanggal']) ?></td>
      <td><?= $row['kategori'] ?></td>
      <td><?= $row['keterangan'] ?></td>
      <td><?= format_rupiah($row['jumlah']) ?></td>
    </tr>
    <?php endwhile; ?>
  </table>
</div>

</body>
</html>
