<?php
// admin/partials/header.php
// Dipakai setelah autentikasi admin (admin/includes/admin_auth.php)

if (session_status() === PHP_SESSION_NONE) session_start();

$ADMIN_NAME = $_SESSION['admin']['full_name'] ?? 'Admin';
$ADMIN_ROLE = $_SESSION['admin']['role'] ?? 'admin';

// Izinkan halaman set $page_title sebelum include header
$page_title = $page_title ?? 'Admin Panel';

// Bantu: deteksi menu aktif
$current = basename($_SERVER['PHP_SELF']);
function is_active(string $file, string $current): string {
  return $current === $file ? 'active' : '';
}
?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title><?php echo htmlspecialchars($page_title, ENT_QUOTES, 'UTF-8'); ?> — Passjek Admin</title>
  <meta name="theme-color" content="#0b7d62" />
  <style>
    :root{
      --bg:#ffffff; --bg-soft:#f7fbfa; --ink:#102a27; --muted:#5b6f6b;
      --brand:#0b7d62; --brand-ink:#074d3e; --accent:#ff7a18;
      --border:#e6ecea; --shadow:0 14px 36px rgba(0,0,0,.08);
      --card:#ffffff; --pill:#eef6f4;
      --sidebar:#ffffff; --sidebar-border:#e6ecea;
    }
    /* Dark mode (toggle class .dark pada <html>) */
    html.dark{
      --bg:#0e1413; --bg-soft:#0f1a18; --ink:#e9f6f3; --muted:#a8b6b3;
      --brand:#13ac86; --brand-ink:#0f8c6d; --accent:#ff8a3a;
      --border:#20312e; --shadow:0 12px 34px rgba(0,0,0,.45);
      --card:#111b19; --pill:#152320;
      --sidebar:#0f1715; --sidebar-border:#1a2725;
    }

    *{box-sizing:border-box}
    html,body{margin:0}
    body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,"Noto Sans",sans-serif;background:var(--bg);color:var(--ink)}

    /* Layout */
    .layout{display:grid; grid-template-columns:260px 1fr; min-height:100vh}
    .sidebar{
      background:var(--sidebar); border-right:1px solid var(--sidebar-border);
      position:sticky; top:0; height:100vh; padding:16px; display:flex; flex-direction:column; gap:14px
    }
    .brand{display:flex; align-items:center; gap:10px; font-weight:900; letter-spacing:.2px}
    .brand .logo{width:34px;height:34px;border-radius:10px;background:linear-gradient(135deg,var(--brand),#0e6f59)}
    .brand .name{color:var(--brand-ink)}
    .ver{font-size:11px; color:var(--muted); padding-left:44px; margin-top:-8px}

    .nav{display:flex; flex-direction:column; gap:6px; margin-top:10px}
    .nav a{
      display:flex; align-items:center; gap:10px; padding:10px 12px; border-radius:12px;
      text-decoration:none; color:var(--ink); border:1px solid transparent; font-weight:700
    }
    .nav a:hover{background:var(--bg-soft)}
    .nav a.active{background:linear-gradient(135deg,var(--brand),var(--brand-ink)); color:#fff}
    .nav svg{width:18px;height:18px; flex:0 0 18px}

    .sidebar-tools{margin-top:auto; display:grid; gap:8px}
    .btn{
      display:flex; align-items:center; justify-content:center; gap:8px;
      border:1.5px solid var(--border); background:var(--card); color:var(--ink);
      padding:10px 12px; border-radius:12px; font-weight:800; text-decoration:none; cursor:pointer
    }
    .btn.full{width:100%}
    .btn.outline{background:transparent}
    .btn:hover{filter:brightness(.98)}

    /* Main */
    .main{min-width:0}
    .topbar{
      position:sticky; top:0; z-index:5; background:var(--card);
      border-bottom:1px solid var(--border); box-shadow:var(--shadow);
      display:flex; align-items:center; justify-content:space-between; gap:12px; padding:10px 14px
    }
    .top-title{font-weight:900; color:var(--brand-ink)}
    .top-actions{display:flex; align-items:center; gap:8px; color:var(--muted)}
    .avatar{width:34px;height:34px;border-radius:999px;background:linear-gradient(180deg,var(--accent),#ff5400); display:inline-block}

    .content{max-width:1200px; margin:0 auto; padding:16px}

    /* Pills */
    .pill{display:inline-flex;align-items:center;gap:6px;background:var(--pill);border:1px solid var(--border);color:var(--muted);padding:6px 10px;border-radius:999px;font-size:12px;font-weight:800}

    /* Responsive & collapsed */
    @media (max-width: 1100px){
      .layout{grid-template-columns:72px 1fr}
      .sidebar .name,.ver,.nav span{display:none}
      .nav a{justify-content:center}
    }
    @media (max-width: 760px){
      .layout{grid-template-columns:1fr}
      .sidebar{position:fixed; left:0; top:0; transform:translateX(-100%); transition:transform .2s ease; width:260px; height:100vh; z-index:20}
      .sidebar.open{transform:translateX(0)}
      .topbar{position:sticky}
    }
    .collapse .sidebar{width:72px}
    .collapse .sidebar .name,.collapse .ver,.collapse .nav span{display:none}
    .collapse .nav a{justify-content:center}
  </style>
</head>
<body>
<div class="layout" id="layout">

  <!-- SIDEBAR -->
  <aside class="sidebar" id="sidebar">
    <div class="brand">
      <div class="logo"></div>
      <div class="name">Passjek Admin</div>
    </div>
    <div class="ver">v1.0</div>

    <nav class="nav">
      <a href="index.php" class="<?php echo is_active('index.php',$current); ?>">
        <!-- dashboard icon -->
        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor"><path d="M3 13h8V3H3v10zm10 8h8V11h-8v10zM3 21h8v-6H3v6zm10-18h8V3h-8v0z" stroke-width="1.6"/></svg>
        <span>Dashboard</span>
      </a>
      <a href="campaigns.php" class="<?php echo is_active('campaigns.php',$current); ?>">
        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor"><path d="M4 6h16M4 12h16M4 18h7" stroke-width="1.6" stroke-linecap="round"/></svg>
        <span>Campaigns</span>
      </a>
      <a href="affiliates.php" class="<?php echo is_active('affiliates.php',$current); ?>">
        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor"><circle cx="8" cy="8" r="3" stroke-width="1.6"/><path d="M2 21a6 6 0 0 1 12 0" stroke-width="1.6"/><circle cx="17" cy="7" r="3" stroke-width="1.6"/><path d="M14.5 21A6.5 6.5 0 0 1 21 14.5" stroke-width="1.6"/></svg>
        <span>Affiliates</span>
      </a>
      <a href="payouts.php" class="<?php echo is_active('payouts.php',$current); ?>">
        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor"><path d="M3 12h18M7 8l-4 4 4 4M13 5h6a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2h-6" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"/></svg>
        <span>Payouts</span>
      </a>
      <!-- Tambah menu admin lain bila perlu -->
    </nav>

    <div class="sidebar-tools">
      <button class="btn full" id="toggleTheme" type="button">🌓&nbsp; Dark Mode</button>
      <button class="btn outline full" id="toggleSidebar" type="button">⟷&nbsp; Collapse</button>
      <a class="btn outline full" href="logout.php">Keluar</a>
      <div class="pill" title="Peran">
        👤 <b><?php echo htmlspecialchars($ADMIN_NAME, ENT_QUOTES, 'UTF-8'); ?></b> · <?php echo htmlspecialchars($ADMIN_ROLE, ENT_QUOTES, 'UTF-8'); ?>
      </div>
    </div>
  </aside>

  <!-- MAIN -->
  <section class="main">
    <div class="topbar">
      <div style="display:flex; align-items:center; gap:8px">
        <button class="btn outline" id="menuBtn" type="button" style="display:none">☰</button>
        <div class="top-title"><?php echo htmlspecialchars($page_title, ENT_QUOTES, 'UTF-8'); ?></div>
      </div>
      <div class="top-actions">
        <span class="pill">Login: <b><?php echo htmlspecialchars($ADMIN_NAME, ENT_QUOTES, 'UTF-8'); ?></b></span>
        <span class="avatar" title="<?php echo htmlspecialchars($ADMIN_NAME, ENT_QUOTES, 'UTF-8'); ?>"></span>
      </div>
    </div>

    <div class="content">
<!-- ^^^ Halaman admin Anda mulai menulis konten di sini. Footer akan menutup .content, .main, dan .layout -->
