<?php include '../includes/db.php'; ?>
<?php include '../includes/navbar.php'; ?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Kredit Emas Syariah</title>
  <style>
    body {
      font-family: sans-serif;
      background: #f5f5f5;
      margin: 0;
      padding: 0;
    }

    .container {
      max-width: 600px;
      margin: 20px auto;
      background: #fff;
      padding: 24px;
      border-radius: 10px;
      box-shadow: 0 4px 10px rgba(0,0,0,0.05);
    }

    h2 {
      text-align: center;
      color: #006400;
      margin-bottom: 20px;
    }

    label {
      display: block;
      margin-bottom: 6px;
      color: #333;
      font-weight: bold;
    }

    input, select {
      width: 100%;
      padding: 10px;
      margin-bottom: 16px;
      border: 1px solid #ccc;
      border-radius: 6px;
    }

    .btn {
      display: block;
      width: 100%;
      background: #ff7f00;
      color: white;
      text-align: center;
      padding: 10px;
      font-size: 16px;
      border: none;
      border-radius: 6px;
      font-weight: bold;
      text-decoration: none;
    }

    .btn:hover {
      background: #e56700;
    }

    .hasil {
      background: #f0f8e2;
      padding: 12px;
      border-radius: 6px;
      margin-top: 20px;
      font-size: 14px;
      color: #333;
    }
  </style>
</head>
<body>

<div class="container">
  <h2>Simulasi Kredit Emas</h2>

  <?php
  // Ambil harga emas dari DB
  $harga_gram = 0;
  $result = mysqli_query($conn, "SELECT * FROM harga_emas ORDER BY id DESC LIMIT 1");
  if ($row = mysqli_fetch_assoc($result)) {
      $harga_gram = $row['harga_per_gram'];
  }
  ?>

  <form method="post">
    <label>Jumlah Emas (gram)</label>
    <input type="number" name="gram" required min="1" value="<?= $_POST['gram'] ?? '' ?>">

    <label>Tenor (bulan)</label>
    <select name="bulan" required>
      <option value="">Pilih</option>
      <?php for ($i=3; $i<=24; $i+=3): ?>
        <option value="<?= $i ?>" <?= (isset($_POST['bulan']) && $_POST['bulan'] == $i) ? 'selected' : '' ?>><?= $i ?> bulan</option>
      <?php endfor; ?>
    </select>

    <label>Nama Lengkap</label>
    <input type="text" name="nama" required value="<?= $_POST['nama'] ?? '' ?>">

    <label>Alamat</label>
    <input type="text" name="alamat" required value="<?= $_POST['alamat'] ?? '' ?>">

    <label>No. WhatsApp</label>
    <input type="text" name="wa" required value="<?= $_POST['wa'] ?? '' ?>">

    <button type="submit" class="btn">Hitung Cicilan</button>
  </form>

  <?php
  if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $gram = (int)$_POST['gram'];
    $bulan = (int)$_POST['bulan'];
    $nama = htmlspecialchars($_POST['nama']);
    $alamat = htmlspecialchars($_POST['alamat']);
    $wa = htmlspecialchars($_POST['wa']);

    $harga_total = $harga_gram * $gram;
    $dp = 0.10 * $harga_total;
    $pinjaman = $harga_total - $dp;
    $bunga = 0.0083 * $bulan * $pinjaman;
    $total_pembayaran = $pinjaman + $bunga;
    $cicilan_bulanan = $total_pembayaran / $bulan;
  ?>

  <div class="hasil">
    <b>Rincian Kredit:</b><br>
    Harga Emas: Rp <?= number_format($harga_total, 0, ',', '.') ?><br>
    Uang Muka (DP 10%): Rp <?= number_format($dp, 0, ',', '.') ?><br>
    Pinjaman: Rp <?= number_format($pinjaman, 0, ',', '.') ?><br>
    Bunga Flat 0.83%/bulan x <?= $bulan ?> bln: Rp <?= number_format($bunga, 0, ',', '.') ?><br>
    <b>Total Pinjaman + Bunga: Rp <?= number_format($total_pembayaran, 0, ',', '.') ?></b><br>
    <b>Cicilan per bulan: Rp <?= number_format($cicilan_bulanan, 0, ',', '.') ?></b><br><br>

    <a class="btn" target="_blank" href="https://wa.me/6289652748080<?= ltrim($wa, '0') ?>?text=Halo%20Admin%20Saya%20ingin%20mengajukan%20kredit%20emas%20%0A%0ANama:%20<?= urlencode($nama) ?>%0AAlamat:%20<?= urlencode($alamat) ?>%0AEmas:%20<?= $gram ?> gram%0ATenor:%20<?= $bulan ?> bulan%0ADP:%20Rp<?= number_format($dp, 0, ',', '.') ?>%0ACicilan/bln:%20Rp<?= number_format($cicilan_bulanan, 0, ',', '.') ?>%0A%0ATerima%20kasih.">Ajukan Sekarang via WhatsApp</a>
  </div>
  <?php } ?>
</div>

<?php include '../includes/footer.php'; ?>
</body>
</html>
