<?php
$base_url = '';
?>

<style> 
  .navbar {
    background: rgb(255, 123, 0);
    padding: 12px 5vw;
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    position: sticky;
    top: 0;
    z-index: 999;
    box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
  }

  .navbar-logo img {
    height: 50px;
    max-width: 100%;
  }

  .navbar-menu {
    display: flex;
    gap: 18px;
    list-style: none;
    margin: 0;
    padding: 0;
  }

  .navbar-menu li a {
    color: #fff;
    text-decoration: none;
    font-weight: bold;
    font-size: 17px; /* ✅ DIPERBESAR DARI 15px */
    padding: 6px 8px;
    border-bottom: 2px solid transparent;
    transition: all 0.3s ease;
  }

  .navbar-menu li a:hover {
    color: #000;
    border-bottom: 2px solid #fff;
    background: rgba(255, 255, 255, 0.3);
    border-radius: 4px;
  }

  .hamburger {
    display: none;
    font-size: 26px;
    color: #fff;
    cursor: pointer;
    background: none;
    border: none;
  }

  @media (max-width: 768px) {
    .navbar-menu {
      display: none;
      flex-direction: column;
      width: 100%;
      margin-top: 10px;
    }

    .navbar-menu.active {
      display: flex;
      background: rgb(255, 123, 0);
      padding: 10px 0;
    }

    .hamburger {
      display: block;
    }

    .navbar-menu li {
      text-align: center;
    }
  }
</style>

<nav class="navbar">
  <div class="navbar-logo">
    <a href="<?= $base_url ?>/index.php">
      <img src="<?= $base_url ?>/assets/img/logo.png" alt="TanganOrangBaik">
    </a>
  </div>

  <button class="hamburger" onclick="toggleMenu()">☰</button>

  <ul class="navbar-menu" id="navMenu">
    <li><a href="<?= $base_url ?>/index.php">Home</a></li>
    <li><a href="<?= $base_url ?>/tentang.php">Tentang Kami</a></li>
    <li><a href="<?= $base_url ?>/voucher_syariah/">Voucher Syariah</a></li>
    <li><a href="<?= $base_url ?>/emas/">Emas</a></li>
    <li><a href="<?= $base_url ?>/all_firdaus/">All Firdaus</a></li>
    <li><a href="<?= $base_url ?>/wakaf/">Wakaf</a></li>
    <li><a href="<?= $base_url ?>/donasi/">Donasi</a></li>
    <li><a href="<?= $base_url ?>/artikel/">Artikel</a></li>
    <li><a href="<?= $base_url ?>/kontak/">Kontak</a></li>
    <li><a href="<?= $base_url ?>/login.php/">Akun</a></li>
  </ul>
</nav>

<script>
  function toggleMenu() {
    document.getElementById("navMenu").classList.toggle("active");
  }
</script>
